/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpersona.onetouch.processing._impl;

import com.digitalpersona.onetouch.DPFPCaptureFeedback;
import com.digitalpersona.onetouch.DPFPDataPurpose;
import com.digitalpersona.onetouch.DPFPFeatureSet;
import com.digitalpersona.onetouch.DPFPGlobal;
import com.digitalpersona.onetouch.DPFPSample;
import com.digitalpersona.onetouch.jni.FeatureExtractionResult;
import com.digitalpersona.onetouch.jni.FeatureExtractor;
import com.digitalpersona.onetouch.jni.JniException;
import com.digitalpersona.onetouch.processing.DPFPFeatureExtraction;
import com.digitalpersona.onetouch.processing.DPFPFeatureExtractionFactory;
import com.digitalpersona.onetouch.processing.DPFPImageQualityException;

public class DPFPFeatureExtractionFactoryImpl
implements DPFPFeatureExtractionFactory {
    public DPFPFeatureExtraction createFeatureExtraction() {
        return new FeatureExtractionImpl();
    }

    private static class FeatureExtractionImpl
    implements DPFPFeatureExtraction {
        private FeatureExtractor featureExtractor;

        public FeatureExtractionImpl() {
            try {
                this.featureExtractor = new FeatureExtractor();
            }
            catch (JniException jniException) {
                throw new RuntimeException(jniException);
            }
        }

        public DPFPFeatureSet createFeatureSet(DPFPSample dPFPSample, DPFPDataPurpose dPFPDataPurpose) throws DPFPImageQualityException {
            if (dPFPDataPurpose == DPFPDataPurpose.DATA_PURPOSE_UNKNOWN) {
                throw new IllegalArgumentException();
            }
            int n = dPFPDataPurpose == DPFPDataPurpose.DATA_PURPOSE_ENROLLMENT ? 0 : (dPFPDataPurpose == DPFPDataPurpose.DATA_PURPOSE_VERIFICATION ? 2 : 0);
            DPFPCaptureFeedback dPFPCaptureFeedback = DPFPCaptureFeedback.CAPTURE_FEEDBACK_NONE;
            try {
                FeatureExtractionResult featureExtractionResult = this.featureExtractor.extractFeatures(dPFPSample.serialize(), n);
                dPFPCaptureFeedback = DPFPCaptureFeedback.values()[featureExtractionResult.featuresQuality];
                if (dPFPCaptureFeedback != DPFPCaptureFeedback.CAPTURE_FEEDBACK_GOOD) {
                    throw new DPFPImageQualityException(dPFPCaptureFeedback);
                }
                return DPFPGlobal.getFeatureSetFactory().createFeatureSet(featureExtractionResult.data);
            }
            catch (JniException jniException) {
                throw new DPFPImageQualityException(DPFPCaptureFeedback.CAPTURE_FEEDBACK_NONE);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new DPFPImageQualityException(DPFPCaptureFeedback.CAPTURE_FEEDBACK_NONE);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new DPFPImageQualityException(DPFPCaptureFeedback.CAPTURE_FEEDBACK_NONE);
            }
        }
    }
}

