/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpersona.onetouch.verification._impl;

import com.digitalpersona.onetouch.DPFPFeatureSet;
import com.digitalpersona.onetouch.DPFPTemplate;
import com.digitalpersona.onetouch.jni.JniException;
import com.digitalpersona.onetouch.jni.Matcher;
import com.digitalpersona.onetouch.jni.VerificationResult;
import com.digitalpersona.onetouch.verification.DPFPVerification;
import com.digitalpersona.onetouch.verification.DPFPVerificationFactory;
import com.digitalpersona.onetouch.verification.DPFPVerificationResult;

public class DPFPVerificationFactoryImpl
implements DPFPVerificationFactory {
    public DPFPVerification createVerification() {
        return new VerificationImpl();
    }

    public DPFPVerification createVerification(int n) {
        return new VerificationImpl(n);
    }

    private static class VerificationImpl
    implements DPFPVerification {
        private Matcher matcher;

        public VerificationImpl() {
            try {
                this.matcher = new Matcher();
            }
            catch (JniException jniException) {
                throw new RuntimeException(jniException);
            }
        }

        public VerificationImpl(int n) {
            this();
            this.setFARRequested(n);
        }

        public synchronized int getFARRequested() {
            try {
                return this.Float2FAR(this.matcher.getFARRequested());
            }
            catch (JniException jniException) {
                return 0;
            }
        }

        public synchronized void setFARRequested(int n) {
            try {
                this.matcher.setFARRequested(this.FAR2Float(n));
            }
            catch (JniException jniException) {
                jniException.printStackTrace();
            }
        }

        public synchronized DPFPVerificationResult verify(DPFPFeatureSet dPFPFeatureSet, DPFPTemplate dPFPTemplate) {
            try {
                VerificationResult verificationResult = this.matcher.verify(dPFPTemplate.serialize(), dPFPFeatureSet.serialize());
                return new VerificationResultImpl(this.Float2FAR(verificationResult.FARAchieved), verificationResult.decision);
            }
            catch (JniException jniException) {
                return new VerificationResultImpl(0, false);
            }
        }

        private int Float2FAR(double d) {
            return Math.max((int)(d * 2.147483647E9), 0);
        }

        private double FAR2Float(int n) {
            return (double)n / 2.147483647E9;
        }

        private static class VerificationResultImpl
        implements DPFPVerificationResult {
            private final int FAR;
            private final boolean verified;

            public VerificationResultImpl(int n, boolean bl) {
                this.FAR = n;
                this.verified = bl;
            }

            public int getFalseAcceptRate() {
                return this.FAR;
            }

            public boolean isVerified() {
                return this.verified;
            }
        }
    }
}

