/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.PrintPiece;
import net.sf.paperclips.internal.Util;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

class ImagePiece
implements PrintPiece {
    private final Device device;
    private final ImageData imageData;
    private final Point size;
    private Image image;

    ImagePiece(Device device, ImageData imageData, Point size) {
        Util.notNull(device, imageData, size);
        this.device = device;
        this.imageData = imageData;
        this.size = size;
    }

    public Point getSize() {
        return new Point(this.size.x, this.size.y);
    }

    private Image getImage() {
        if (this.image == null) {
            this.image = new Image(this.device, this.imageData);
        }
        return this.image;
    }

    public void paint(GC gc, int x, int y) {
        gc.drawImage(this.getImage(), 0, 0, this.imageData.width, this.imageData.height, x, y, this.size.x, this.size.y);
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
    }
}

